<?php

/*
Welcome Guest Plugin for MyBB
Copyright (C) 2010 Sebastian Wunderlich

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

if(!defined('IN_MYBB'))
{
	die();
}

$plugins->add_hook('index_start','welcomeguest');
$plugins->add_hook('portal_start','welcomeguest');

function welcomeguest_info()
{
	return array
	(
		'name'=>'هاك رساله ترحيب بالزوار',
		'description'=>'Shows a welcome box to guests on index and portal page.',
		'website'=>'http://mods.mybboard.net/view/welcome-guest',
		'author'=>'Sebastian Wunderlich',
		'version'=>'1.5',
		'guid'=>'dfa72aaaefe210a7714d8a856ff12534',
		'compatibility'=>'14*,16*'
	);
}

function welcomeguest_activate()
{
	require_once MYBB_ROOT.'/inc/adminfunctions_templates.php';
	find_replace_templatesets('index','#'.preg_quote('{$welcomeguest}
').'#i','',0);
	find_replace_templatesets('portal','#'.preg_quote('{$welcomeguest}
').'#i','',0);
	find_replace_templatesets('index','#'.preg_quote('{$forums}').'#i','{$welcomeguest}
{$forums}');
	find_replace_templatesets('portal','#'.preg_quote('{$announcements}').'#i','{$welcomeguest}
{$announcements}');
}

function welcomeguest_deactivate()
{
	require_once MYBB_ROOT.'/inc/adminfunctions_templates.php';
	find_replace_templatesets('index','#'.preg_quote('{$welcomeguest}
').'#i','',0);
	find_replace_templatesets('portal','#'.preg_quote('{$welcomeguest}
').'#i','',0);
}

function welcomeguest_lang()
{
	global $lang;
	$lang->load('welcomeguest',false,true);
	$l['welcomeguest_header']='اهلا وسهلا بكم';
	$l['welcomeguest_message']='اهلا وسهلا بكم في منتديات الدعم العربي الاول لنسخة mybb ';
	foreach($l as $key=>$val)
	{
		if(!$lang->$key)
		{
			$lang->$key=$val;
		}
	}
}

function welcomeguest()
{
	global $mybb;
	if($mybb->user['usergroup']==1)
	{
		global $theme,$lang,$welcomeguest;
		welcomeguest_lang();
		$welcomeguest='<table border="0" cellspacing="'.$theme['borderwidth'].'" cellpadding="'.$theme['tablespace'].'" class="tborder">
	<thead>
		<tr>
			<td class="thead">
				<strong>'.$lang->welcomeguest_header.'</strong>
			</td>
		</tr>
	</thead>
	<tbody>
		<tr>
			<td class="trow1">'.$lang->welcomeguest_message.'</td>
		</tr>
	</tbody>
</table>
<br />';
	}
}

?>